    function createCalendar(year, month) {
    const calendarTitle = document.getElementById('calendar-title');
    const monthNames = ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'];
    calendarTitle.textContent = `${monthNames[month - 1]} ${year}`;

    const calendar = document.getElementById('calendar');
    calendar.innerHTML = '';

    const date = new Date(year, month - 1);
    const daysInMonth = new Date(year, month, 0).getDate();
    const firstDayIndex = date.getDay() === 0 ? 6 : date.getDay() - 1;
    const weeksInMonth = Math.ceil((daysInMonth + firstDayIndex) / 7);
    const today = new Date();
    const isCurrentMonth = (today.getFullYear() === year && today.getMonth() + 1 === month);

    let table = '<table>';
    table += '<tr><th class="kw-column">KW</th><th>Mo</th><th>Di</th><th>Mi</th><th>Do</th><th>Fr</th><th>Sa</th><th>So</th></tr>';

    let currentDay = 1;
    for (let week = 0; week < weeksInMonth; week++) {
        table += '<tr>';
        const currentWeekNumber = getWeekNumber(new Date(year, month - 1, currentDay));
        table += `<td class="kw-column">${currentWeekNumber}</td>`;

        for (let day = 0; day < 7; day++) {
            if ((week === 0 && day < firstDayIndex) || currentDay > daysInMonth) {
                table += '<td></td>';
            } else {
                const isToday = isCurrentMonth && currentDay === today.getDate();
                const cellClass = isToday ? 'current-day' : '';
                table += `<td class="${cellClass}">${currentDay}</td>`;
                currentDay++;
            }
        }
        table += '</tr>';
    }

    table += '</table>';
    calendar.innerHTML = table;
}

function getWeekNumber(date) {
    const firstDayOfYear = new Date(date.getFullYear(), 0, 1);
    const pastDaysOfYear = (date - firstDayOfYear) / 86400000;
    return Math.ceil((pastDaysOfYear + firstDayOfYear.getDay() + 1) / 7);
}

createCalendar(new Date().getFullYear(), new Date().getMonth() + 1);  

// Funktion zum Überprüfen des Schlüsselworts
document.addEventListener("DOMContentLoaded", function() {
    const searchField = document.getElementById('searchField');
    const kwContainer = document.getElementById('kwContainer');

    searchField.addEventListener('input', function() {
        const inputValue = searchField.value.trim();
        if (inputValue.toUpperCase() === 'vs') {
            kwContainer.style.display = 'block'; // Zeige das geheime div an
        } else {
            kwContainer.style.display = 'none'; // Verstecke das geheime div
        }
    });
});